<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class MainController extends Controller
{
    public function index()
    {
        $about = Storage::exists('about.txt') ? Storage::get('about.txt') : '';
        $products = Storage::exists('products.txt') ? Storage::get('products.txt') : '';
        $slider_files = Storage::files('public/slider');
        $sliders = array_map(function($path) {
            return basename($path);
        }, $slider_files);

        return view('beranda', compact('about', 'products', 'sliders'));
    }
}

class AdminController extends Controller
{
    public function index()
    {
        $about = Storage::exists('about.txt') ? Storage::get('about.txt') : '';
        $products = Storage::exists('products.txt') ? Storage::get('products.txt') : '';
        return view('admin', compact('about', 'products'));
    }

    public function uploadSlider(Request $request)
    {
        if ($request->hasFile('slider_image')) {
            $file = $request->file('slider_image');
            $filename = time().'_'.$file->getClientOriginalName();
            $file->storeAs('public/slider', $filename);
        }
        return redirect('/admin-panel');
    }

    public function saveAbout(Request $request)
    {
        Storage::put('about.txt', $request->about_content);
        return redirect('/admin-panel');
    }

    public function saveProducts(Request $request)
    {
        Storage::put('products.txt', $request->products_content);
        return redirect('/admin-panel');
    }
}